#include "mapinc.h"



DECLFW(Mapper73_write)
{
switch(A&0xF000)
 {
 case 0x8000:IRQCount&=0xFFF0;IRQCount|=(V&0xF);break;
 case 0x9000:IRQCount&=0xFF0F;IRQCount|=(V&0xF)<<4;break;
 case 0xa000:IRQCount&=0xF0FF;IRQCount|=(V&0xF)<<8;break;
 case 0xb000:IRQCount&=0x0FFF;IRQCount|=(V&0xF)<<12;break;
 case 0xc000:IRQa=V&2;break;
 case 0xf000:ROM_BANK16(0x8000,V);break;
 }
}

static void FP_FASTAPASS(1) Mapper73IRQHook(int a)
{
 if(IRQa)
 {
  IRQCount+=a;
  if(IRQCount>=0xFFFF)
  {
   IRQCount&=0xFFFF;
   IRQa=0;
   TriggerIRQ();
  }
 }
}

void Mapper73_init(void)
{
 SetWriteHandler(0x8000,0xffff,(void *)Mapper73_write);
 MapIRQHook=Mapper73IRQHook;
}

