#include "mapinc.h"

static DECLFW(Mapper77_write)
{
 mapbyte1[0]=V;
 ROM_BANK32((V & 0x07));
 VROM_BANK2(0x0000, ((V & 0xf0) >> 4));
}

static void Mapper77_StateRestore(int version)
{
 int x;
 
 if(version>=72)
 {
  ROM_BANK32((mapbyte1[0] & 0x07));
  VROM_BANK2(0x0000, ((mapbyte1[0] & 0xf0) >> 4));
 }
 for(x=2;x<8;x++)
  VRAM_BANK1(x*0x400,x);
}

void Mapper77_init(void)
{
 int x;

 ROM_BANK32(0);
 for(x=2;x<8;x++)
  VRAM_BANK1(x*0x400,x);
 SetWriteHandler(0x6000,0xffff,(void *)Mapper77_write);
 MapStateRestore=(void *)Mapper77_StateRestore;
}
