#include "mapinc.h"

#define ctrl	mapbyte1[6]

static void DoCHR(void)
{
 int x;

 for(x=0;x<2;x++)
  VROM_BANK2((x<<11)|((ctrl&2)<<11),mapbyte1[x]>>1);
 for(x=0;x<4;x++)
  VROM_BANK1((x<<10) | (((ctrl&2)^2)<<11),mapbyte1[2+x]);
}

static DECLFW(Mapper82_write)
{
 if(A<=0x7EF5)
 {
  mapbyte1[A&7]=V;
  DoCHR();
 }
 else
  switch(A)
  {
   case 0x7ef6:ctrl=V&3;
	       MIRROR_SET2(V&1);
 	       DoCHR();
  	       break;
   case 0x7efa:V>>=2;mapbyte2[0]=V;ROM_BANK8(0x8000,V);break;
   case 0x7efb:V>>=2;mapbyte2[1]=V;ROM_BANK8(0xa000,V);break;
   case 0x7efc:V>>=2;mapbyte2[2]=V;ROM_BANK8(0xc000,V);break;
  }
}

void Mapper82_init(void)
{
 ROM_BANK8(0xE000,~0);

 /* external WRAM might end at $73FF */
 SetWriteHandler(0x7ef0,0x7efc,(void *)Mapper82_write);
}

