#include "mapinc.h"

DECLFW(Mapper92_write)
{
  uint8 bank, data;

  data = (uint8) (A & 0xFF);
  bank = (data & 0x0F);

  if (A >= 0x9000) {
    if ((data & 0xF0) == 0xD0)
      ROM_BANK16(0xC000, bank);
    else if ((data & 0xF0) == 0xE0)
      VROM_BANK8(bank);
  } else {
    if ((data & 0xF0) == 0xB0)
      ROM_BANK16(0xC000, bank);
    else if ((data & 0xF0) == 0x70)
      VROM_BANK8(bank);
  }
}

void Mapper92_init(void)
{
  SetWriteHandler(0x8000,0xFFFF,(void *)Mapper92_write);
}
