#include "mapinc.h"

static uint8 latche;

static DECLFW(Mapper2_write)
{
	latche=V;
        ROM_BANK16(0x8000,V);
}

void Mapper2_init(void)
{
  SetWriteHandler(0x8000,0xFFFF,(void *)Mapper2_write);
  AddExState(&latche, 1, 0, "LATC");
}

static DECLFW(Mapper3_write)
{
        VROM_BANK8(V);
	latche=V;
}

void Mapper3_init(void)
{
	SetWriteHandler(0x8000,0xFFFF,(void *)Mapper3_write);
	AddExState(&latche, 1, 0, "LATC");
}

DECLFW(Mapper7_write)
{
      ROM_BANK32(V&0xF);
      onemir((V>>4)&1);
      latche=V;
}

void Mapper7_init(void)
{
        onemir(0);
        SetWriteHandler(0x8000,0xFFFF,(void *)Mapper7_write);
	AddExState(&latche, 1, 0, "LATC");
}

DECLFW(Mapper11_write)
{
        ROM_BANK32(V);
        VROM_BANK8(V>>4);
	latche=V;
}

void Mapper11_init(void)
{
        ROM_BANK32(0);
	SetWriteHandler(0x8000,0xFFFF,(void *)Mapper11_write);
	AddExState(&latche, 1, 0, "LATC");
}

static INLINE void VRAM_BANK4(uint32 A,uint32 V)
{
VPage[(A)>>10]=VPage[((A)>>10)+1]=VPage[((A)>>10)+2]=VPage[((A)>>10)+3]=&MapperExRAM[(V)<<12]-(A);
CHRBankList[(A)>>10]=((V)<<2);
CHRBankList[((A)>>10)+1]=((V)<<2)+1;
CHRBankList[((A)>>10)+2]=((V)<<2)+2;CHRBankList[((A)>>10)+3]=((V)<<2)+3;
}



DECLFW(Mapper13_write)
{
	VRAM_BANK4(0x1000,V&3);
	ROM_BANK32((((V>>4)&3)));
	latche=V;
}

void Mapper13_StateRestore(int version)
{
	VRAM_BANK4(0x1000,latche&3);
	ROM_BANK32((((latche>>4)&3)));
}
void Mapper13_init(void)
{
	VRAM_BANK4(0,0);VRAM_BANK4(0x1000,1);
	SetWriteHandler(0x8000,0xFFFF,(void *)Mapper13_write);
	MapStateRestore=(void *)Mapper13_StateRestore;
	AddExState(&latche, 1, 0, "LATC");
}

DECLFW(Mapper34_write)
{
switch(A)
 {
 case 0x7FFD:ROM_BANK32(V);break;
 case 0x7FFE:VROM_BANK4(0x0000,V);break;
 case 0x7fff:VROM_BANK4(0x1000,V);break;
 }
if(A>=0x8000)
 ROM_BANK32(V);
}

void Mapper34_init(void)
{
  SetWriteHandler(0x7ffd,0xffff,(void *)Mapper34_write);
}

DECLFW(Mapper66_write)
{
 VROM_BANK8(V&0xF);
 ROM_BANK32((V>>4));
 latche=V;
}

void Mapper66_init(void)
{
 ROM_BANK32(0);
 SetWriteHandler(0x6000,0xffff,(void *)Mapper66_write);
 AddExState(&latche, 1, 0, "LATC");
}

DECLFW(Mapper70_write)
{
 ROM_BANK16(0x8000,V>>4);
 VROM_BANK8(V&0xF);
 MIRROR_SET((V>>3)&1);
 latche=V;
}

void Mapper70_init(void)
{
 SetWriteHandler(0x8000,0xffff,(void *)Mapper70_write);
 AddExState(&latche, 1, 0, "LATC");
}


DECLFW(Mapper78_write)
{
 ROM_BANK16(0x8000,V);
 VROM_BANK8(V>>4);
 latche=V;
}

void Mapper78_init(void)
{
 SetWriteHandler(0x8000,0xffff,(void *)Mapper78_write);
 AddExState(&latche, 1, 0, "LATC");
}

DECLFW(Mapper87_write)
{
 VROM_BANK8(V>>1);
 latche=V;
}

void Mapper87_init(void)
{
 SetWriteHandler(0x6000,0xffff,(void *)Mapper87_write);
 AddExState(&latche, 1, 0, "LATC");
}

DECLFW(Mapper93_write)
{
  ROM_BANK16(0x8000,V>>4);
  MIRROR_SET(V&1);
  latche=V;
}

void Mapper93_init(void)
{
  SetWriteHandler(0x8000,0xffff,(void *)Mapper93_write);
  AddExState(&latche, 1, 0, "LATC");
}


DECLFW(Mapper94_write)
{
 ROM_BANK16(0x8000,V>>2);
 latche=V;
}

void Mapper94_init(void)
{
  SetWriteHandler(0x8000,0xffff,(void *)Mapper94_write);
  AddExState(&latche, 1, 0, "LATC");
}

DECLFW(Mapper96_write)
{
 ROM_BANK32(V&3);
 latche=V;
}

void Mapper96_init(void)
{
 SetWriteHandler(0x8000,0xffff,(void *)Mapper96_write);
 AddExState(&latche, 1, 0, "LATC");
}
