#include <stdio.h>
#include <stdlib.h>
#include "mapinc.h"
#include "fmopl.h"

FM_OPL *fmob=0;

static void initopl(int how);

void writeopl(uint8 A, uint8 V)
{
 MapperExRAM[A]=V;
 if(fmob) {OPLWrite(fmob,0,A);OPLWrite(fmob,1,V);}
}


void LoadOPL(void)
{
 int x;
 int y;
 for(x=y=0;x<0xF6;x++)
  y|=MapperExRAM[x];
 if(y)
 { 
  initopl(1); 
  for(x=0;x<0xF6;x++)
   writeopl(x,MapperExRAM[x]);
 }
}

static int dwave=0;

void VRC7Update(void)
{
 int32 z,a;

 z=((timestamp<<16)/soundtsinc)>>4;  
 a=z-dwave;

 if(a && fmob)
  YM3812UpdateOne(fmob, &Wave[dwave], a);
 dwave+=a;
}

void UpdateOPL(int Count)
{
 int32 z,a;

 z=((timestamp<<16)/soundtsinc)>>4;
 a=z-dwave;

 if(fmob && a)
  YM3812UpdateOne(fmob, &Wave[dwave], a);

 dwave=0;
}

void KillOPL(void)
{
 if(fmob) OPLDestroy(fmob);
 fmob=0;
}

static void initopl(int how)
{
        int x;


	if(!fmob)
	{	
         fmob=OPLCreate(OPL_TYPE_WAVESEL,1789772*2,FSettings.SndRate);
         if(!fmob ) return;
	}
	GameExpSound.Kill=(void *)KillOPL;
        OPLResetChip(fmob);

        if(!how)
        {
          for(x=0x1;x<0xF6;x++)
           writeopl(x,0);
          writeopl(0xBD,0xC0);
          writeopl(1,0x20);      // Enable waveform type manipulation
        }
}

#include "vrc7q.c"
