#ifdef NETWORK

#include <stdio.h>
#include <stdlib.h>

#include "types.h"
#include "svga.h"
#include "netplay.h"

uint8 netplay=0;        /*      1 if we are a server */
                        /*      2 if we need a host  */

uint8 netskip=3;

static void NetError(void);
static int SendCommand(uint8 c)
{
  uint8 x;

  x=0xFF;

  if(!FCEUD_NetworkSendByte(&x)) {NetError();return 0;};
  if(!FCEUD_NetworkSendByte(&c)) {NetError();return 0;}
  return 1;
}



static void NetError(void)
{
 FCEU_DispMessage("Network error/connection lost!");
 netplay=0;
 FCEUD_NetworkClose();
}

void KillNetplay(void)
{
 if(netplay)
 {
  FCEUD_NetworkClose();
  netplay=0;
 }
}

static uint8 netcount;
int InitNetplay(void)
{
         if(!FCEUD_NetworkConnect())
          {NetError();return 0;}
         netplay=FSettings.NetworkPlay;
         if(netplay==1)
         {
          if(!FCEUD_NetworkSendByte(&netskip)) {NetError();return 0;}
         }
         else if(netplay==2)
         {
          if(!FCEUD_NetworkRecvByte(&netskip)) {NetError();return 0;}
         }
	 netcount=0;
         return 1;
}

static uint8 netlast=0;
static uint8 netlastremote=0;

void NetplayUpdate(uint16 *JS1, uint16 *JS2)
{
 if(netplay==1)         // We're a server
 {
  if(!netcount)
   {
    netlast=(*JS1&0xFF)|((*JS1>>8)&0xFF)|((*JS2)&0xFF)|((*JS2>>8)&0xFF);    // Combine joysticks on this end

    if(CommandQueue)
    {
     if(!SendCommand(CommandQueue)) return;
    }
    if(netlast==0xFF) netlast&=0x7F;
    if(!FCEUD_NetworkSendByte(&netlast)) {NetError();return;}
    if(!FCEUD_NetworkRecvByte(&netlastremote)) {NetError();return;}

    if(CommandQueue)
    {
     DoCommand(CommandQueue);     
     CommandQueue=0;
    }

   }
  *JS1=netlast;
  *JS2=netlastremote;
 }
 else if(netplay==2)    // We're connected to a host (we're second player)
 {
  uint8 temp;
  if(!netcount)
   {
   netlast=(*JS1&0xFF)|((*JS1>>8)&0xFF)|((*JS2)&0xFF)|((*JS2>>8)&0xFF);    // Combine joysticks on this end

   if(netlast==0xFF) netlast&=0x7F;
   if(!FCEUD_NetworkSendByte(&netlast)) {NetError();return;}

   refetch:
   if(!FCEUD_NetworkRecvByte(&temp)) {NetError();return;}

   if(temp==0xFF)
    {
    if(!FCEUD_NetworkRecvByte(&temp)) {NetError();return;}
    DoCommand(temp);
    goto refetch;
    }

   netlastremote=temp;
   }
  *JS2=netlast;
  *JS1=netlastremote;
 }
 if(netskip) netcount=(netcount+1)%netskip;
}
#endif
