#include        <string.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	"m6502.h"
#include	"types.h"
#include	"fce.h"
#include	"version.h"
#include	"input.h"
#include	"powerpad.h"


static uint32 pprsb[2];
static uint32 pprdata[2];

static DECLFR(PPA4016)
{
                uint8 ret=M.DB&0xE0;
                ret|=((pprdata[0]>>pprsb[0])&1)<<3;
                ret|=((pprdata[0]>>(pprsb[0]+8))&1)<<4;
                pprsb[0]++;
                return ret;
}

static DECLFR(PPA4017)
{
                uint8 ret=M.DB&0xE0;
                ret|=((pprdata[1]>>pprsb[1])&1)<<3;
                ret|=((pprdata[1]>>(pprsb[1]+8))&1)<<4;
                pprsb[1]++;
                return ret;
}

static void PP1Strobe(void)
{
		pprsb[0]=0;
}
static void PP2Strobe(void)
{                              
		pprsb[1]=0;
}

void FASTAPASS(2) UpdatePowerpad(int w, uint32 *ptr)
{
        pprdata[w]=*ptr;
}

void HookPowerpad(int w)
{
        if(w)
        {
         SetReadHandler(0x4017,0x4017,(void*)PPA4017);
         PStrobe[1]=PP2Strobe;
        }
        else
        {
         SetReadHandler(0x4016,0x4016,(void*)PPA4016);
         PStrobe[0]=PP1Strobe;
        }
}
