/*                      SVGA High Level Routines
                          FCE / FCE Ultra
*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#include <stdarg.h>

#include "..\stdfile.h"

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

#include "types.h"
#include "svga.h" 
#include "fce.h"
#include "general.h"
#include "video.h"
#include "sound.h"
#include "version.h"
#include "nsf.h"
#include "palette.h"
#include "fds.h"
#include "netplay.h"
#include "state.h"
#include "cart.h"
#include "zapper.h"

FCEUS FSettings;

static int howlong;
static char errmsg[65];

void FCEU_PrintError(char *format, ...)
{
 char temp[2048];

 va_list ap;

 va_start(ap,format);
 vsprintf(temp,format,ap);
 FCEUD_PrintError(temp);

 va_end(ap);
}

void FCEU_DispMessage(char *format, ...)
{
 va_list ap;

 va_start(ap,format);
 vsprintf(errmsg,format,ap);
 va_end(ap);

 howlong=180;
}

void FCEUI_SetFirstRenderedLine(int a)
{
 FSettings.FirstSLine=a;
}

void FCEUI_SetLastRenderedLine(int a)
{
 FSettings.LastSLine=a;
}

void FCEUI_SetVidSystem(int a)
{
 FSettings.PAL=a?1:0;
 if(!(GameAttributes&GA_NSF))
  SetVideoSystem(a);
 ResetPalette();
}

#ifdef NETWORK
void FCEUI_SetNetworkPlay(int type, int skip)
{
 FSettings.NetworkPlay=type;
 FSettings.NetworkPlaySkip=skip;
}
#endif

void FCEUI_SetGameGenie(int a)
{
 FSettings.GameGenie=a?1:0;
}

static void CalculatePalette(void);
static void ChoosePalette(void);
static void WritePalette(void);

#ifndef NETWORK
#define netplay 0
#endif

static uint8 StateShow=0;

uint8 Exit=0;

uint8 DIPS=0;
uint8 vsdip=0;
int coinon=0;

uint8 pale=0;
uint8 CommandQueue=0;

static int controlselect=0;
static int ntsccol=0;
static int ntsctint=46+10;
static int ntschue=72;
static int controllength=0;

pal *palo;
static pal *palpoint[8]=
     {
     palette,
     palettevscv,
     palettevssmb,
     palettevsmar,
     palettevsgoon,
     palettevsslalom,
     palettevseb,
     rp2c04001
     };

void FCEUI_SaveExtraDataUnderBase(int a)
{
 FSettings.SUnderBase=a;
}

void FCEUI_SetPaletteArray(uint8 *pal)
{
 if(!pal)
  palpoint[0]=palette;
 else
 {
  int x;
  palpoint[0]=palettec;
  for(x=0;x<64;x++)
  {
   palpoint[0][x].r=*((uint8 *)pal+x+x+x);
   palpoint[0][x].g=*((uint8 *)pal+x+x+x+1);
   palpoint[0][x].b=*((uint8 *)pal+x+x+x+2);
  }
 }
 ResetPalette();
}

void FCEUI_SetBaseDirectory(char *dir)
{
 strncpy(BaseDirectory,dir,2047);
 BaseDirectory[2047]=0;
}


void DriverInterface(int w, void *d)
{
 switch(w)
 {
  case DES_GETDESIREDFPS:if(PAL)
                          *(uint32 *)d=50<<24;
                         else
                          *(uint32 *)d=1008285147;
                         break;
  case DES_NTSCCOL:ntsccol=*(int *)d;ResetPalette();break;
  case DES_RESET:if(netplay!=2) CommandQueue=30;break;
  case DES_POWER:if(netplay!=2) CommandQueue=31;break;
  case DES_GETNTSCTINT:*(int*)d=ntsctint;break;
  case DES_GETNTSCHUE:*(int*)d=ntschue;break;
  case DES_SETNTSCTINT:ntsctint=*(int*)d;if(ntsccol)ResetPalette();break;
  case DES_SETNTSCHUE:ntschue=*(int*)d;if(ntsccol)ResetPalette();break;
  case DES_DISPMESSAGE:FCEU_DispMessage((char *)d);break;
  case DES_SAVESNAP:
		    {
		     int x=SaveSnapshot();
		     if(!x)
		      FCEU_DispMessage("Error saving screen snapshot.");
		     else
		      FCEU_DispMessage("Screen snapshot %d saved.",x-1);
		    }
		    break;
  case DES_FDSINSERT:if(netplay!=2) CommandQueue=2;break;
  case DES_FDSEJECT:if(netplay!=2) CommandQueue=3;break;
  case DES_FDSSELECT:if(netplay!=2) CommandQueue=1;break;
  case DES_NSFINC:NSFControl(1);break;
  case DES_NSFDEC:NSFControl(2);break;
  case DES_NSFRES:NSFControl(0);break;  
  case DES_SAVESTATE:if(netplay!=2 && !(GameAttributes&GA_NSF)) CommandQueue=40;break;
  case DES_LOADSTATE:if(netplay!=2 && !(GameAttributes&GA_NSF)) CommandQueue=41;break;
  case DES_SELECTSTATE:if(netplay!=2 && !(GameAttributes&GA_NSF)) CommandQueue=42+(int)d;break;
  case DES_VSUNIDIPSET:CommandQueue=10+(int)d;break;
  case DES_VSUNITOGGLEDIPVIEW:CommandQueue=10;break;
  case DES_VSUNICOIN:CommandQueue=19;break;
  case DES_NTSCSELHUE:if(ntsccol && !(GameAttributes&GA_VSUNI) && !PAL && !(GameAttributes&GA_NSF)){controlselect=1;controllength=360;}break;
  case DES_NTSCSELTINT:if(ntsccol && !(GameAttributes&GA_VSUNI) && !PAL && !(GameAttributes&GA_NSF)){controlselect=2;controllength=360;}break;

  case DES_NTSCDEC:
		  if(ntsccol && !(GameAttributes&GA_VSUNI) && !PAL && !(GameAttributes&GA_NSF))
		  {
		   char which;
		   if(controlselect)
		   {
		    if(controllength)
		    {
		     which=controlselect==1?ntschue:ntsctint;
		     which--;
		     if(which<0) which=0;
			 if(controlselect==1) 
			  ntschue=which;		     
			 else ntsctint=which;		     
		     CalculatePalette();
		    }
		   controllength=360;
		    }
		   }
		  break;
  case DES_NTSCINC:	
		   if(ntsccol && !(GameAttributes&GA_VSUNI) && !PAL && !(GameAttributes&GA_NSF))
		     if(controlselect)
		     {
		      if(controllength)
		      {
		       switch(controlselect)
		       {
		        case 1:ntschue++;
		               if(ntschue>128) ntschue=128;
		               CalculatePalette();
		               break;
		        case 2:ntsctint++;
		               if(ntsctint>128) ntsctint=128;
		               CalculatePalette();
		               break;
		       }
		      }
		      controllength=360;
		     }
          	    break;
  }
}

static int lastd=-1;

void SetNESDeemph(uint8 d, uint8 f)
{
 static uint16 rtmul[7]={32768*1.239,32768*.794,32768*1.019,32768*.905,32768*1.023,32768*.741,32768*.75};
 static uint16 gtmul[7]={32768*.915,32768*1.086,32768*.98,32768*1.026,32768*.908,32768*.987,32768*.75};
 static uint16 btmul[7]={32768*.743,32768*.882,32768*.653,32768*1.277,32768*.979,32768*.101,32768*.75};
 uint32 r,g,b;
 int x;

 if(!f) if(d==lastd) return;
 if(!d) return;

  r=rtmul[d-1];
  g=gtmul[d-1];
  b=btmul[d-1];

    for(x=0;x<0x40;x++)
    {
     uint32 m,n,o;

     m=palo[x].r;
     n=palo[x].g;
     o=palo[x].b;
     m=(m*r)>>15;
     n=(n*g)>>15;
     o=(o*b)>>15;
     if(m>0xff) m=0xff;
     if(n>0xff) n=0xff;
     if(o>0xff) o=0xff;

     FCEUD_SetPalette(x|0xC0,m,n,o);
    }
 lastd=d;
}

#define HUEVAL  ((double)((double)ntschue/(double)2)+(double)300)
#define TINTVAL ((double)((double)ntsctint/(double)128))

static void CalculatePalette(void)
{
 int x,z;
 int r,g,b;
 double s,y,theta;
 static uint8 cols[16]={0,24,21,18,15,12,9,6,3,0,33,30,27,0,0,0};
 static uint8 br1[4]={6,9,12,12};
 static double br2[4]={.29,.45,.73,.9};
 static double br3[4]={0,.24,.47,.77};
  
 for(x=0;x<=3;x++)
  for(z=0;z<16;z++)
  {
   s=(double)TINTVAL;
   y=(double)br2[x];
   if(z==0)  {s=0;y=((double)br1[x])/12;}
   
   if(z>=13)
   {
    s=y=0;
    if(z==13)
     y=(double)br3[x];     
   }

   theta=(double)M_PI*(double)(((double)cols[z]*10+HUEVAL)/(double)180);
   r=(int)(((double)y+(double)s*(double)sin(theta))*(double)256);
   g=(int)(((double)y-(double)((double)27/(double)53)*s*(double)sin(theta)+(double)((double)10/(double)53)*s*cos(theta))*(double)256);
   b=(int)(((double)y-(double)s*(double)cos(theta))*(double)256);  

   // TODO:  Fix RGB to compensate for phosphor changes(add to red??).

   if(r>255) r=255;
   if(g>255) g=255;
   if(b>255) b=255;
   if(r<0) r=0;
   if(g<0) g=0;
   if(b<0) b=0;
    
   paletten[(x<<4)+z].r=r;
   paletten[(x<<4)+z].g=g;
   paletten[(x<<4)+z].b=b;
  }
 WritePalette();
}

#include "drawing.h"

void PutImage(void)
{
        if(GameAttributes&GA_NSF)
         DrawNSF(XBuf);
        else
        {	
	 if(GameAttributes&GA_VSUNI && DIPS&2)         
	  DrawDips();
         if(StateShow) DrawState();
         if(controllength) {controllength--;DrawBars();}
        }
	DrawMessage();
        FCEUD_BlitScreen(XBuf+8);
	#ifdef FPS
	{
	extern uint64 frcount;
	frcount++;
	}
	#endif
}

static int ipalette=0;

void LoadGamePalette(void)
{
  FILE *fp;
  ipalette=0;
  if((fp=fopen(FCEU_MakeFName(0,"pal",-1,"gameinfo",0),"rb")))
  {
   int x;
   fread(TempArray,1,192,fp);
   fclose(fp);
   for(x=0;x<64;x++)
   {
    palettei[x].r=TempArray[x+x+x];
    palettei[x].g=TempArray[x+x+x+1];
    palettei[x].b=TempArray[x+x+x+2];
   }
   ipalette=1;
  }
}

void ResetPalette(void)
{
   ChoosePalette();
   WritePalette();
}

void ChoosePalette(void)
{
    if(GameAttributes&GA_NSF)
     palo=NSFPalette;   
    else if(ipalette)
     palo=palettei;
    else if(ntsccol && !PAL && !(GameAttributes&GA_VSUNI))
     {
      palo=paletten;
      CalculatePalette();
     }
    else
     palo=palpoint[pale];  
}

void WritePalette(void)
{
    int x;

    for(x=0;x<6;x++)
     FCEUD_SetPalette(x+128,unvpalette[x].r,unvpalette[x].g,unvpalette[x].b);
    if(GameAttributes&GA_NSF)
    {
     for(x=0;x<39;x++)
      FCEUD_SetPalette(x,palo[x].r,palo[x].g,palo[x].b); 
    }
    else
    {
     for(x=0;x<128;x++)
      FCEUD_SetPalette(x,palo[x&0x3f].r,palo[x&0x3f].g,palo[x&0x3f].b);
     SetNESDeemph(lastd,1);
    }
}

void FlushCommandQueue(void)
{
  if(!netplay && CommandQueue) {DoCommand(CommandQueue);CommandQueue=0;}
}

void DoCommand(uint8 c)
{
 switch(c)
 {
  case 1:FDSControl(FDS_SELECT);break;
  case 2:FDSControl(FDS_IDISK);break;
  case 3:FDSControl(FDS_EJECT);break;

  case 10:DIPS^=2;break;
  case 11:vsdip^=1;DIPS|=2;break;
  case 12:vsdip^=2;DIPS|=2;break;
  case 13:vsdip^=4;DIPS|=2;break;
  case 14:vsdip^=8;DIPS|=2;break;
  case 15:vsdip^=0x10;DIPS|=2;break;
  case 16:vsdip^=0x20;DIPS|=2;break;
  case 17:vsdip^=0x40;DIPS|=2;break;
  case 18:vsdip^=0x80;DIPS|=2;break;
  case 19:coinon=6;break;
  case 30:ResetNES();break;
  case 31:PowerNES();break;
  case 40:CheckStates();StateShow=0;SaveState();break;
  case 41:CheckStates();StateShow=0;LoadState();break;
  case 42: case 43: case 44: case 45: case 46: case 47: case 48: case 49:
  case 50: case 51:StateShow=180;CurrentState=c-42;CheckStates();break;
 }
}
