#ifndef __FCEU_TYPES
#define __FCEU_TYPES

typedef unsigned char uint8;
typedef unsigned short uint16;
typedef unsigned long  uint32;

#ifdef __GNUC__
 typedef unsigned long long uint64;
 typedef long long int64;
 #define INLINE inline
 #define GINLINE inline
#else
 // MSVC
 typedef __int64 int64;
 typedef unsigned __int64 uint64;
 #define INLINE __inline
 #define GINLINE
 #define PSS_STYLE 2
 #pragma warning( disable : 4244 4018 4761 )
#endif
typedef signed char int8;
typedef signed short int16;
typedef signed long int32;

#define byte uint8
#define word uint16

typedef union
{
#ifdef LSB_FIRST
  struct { uint8 l,h; } B;
#else
  struct { uint8 h,l; } B;
#endif
  uint16 W;
} pair;

typedef union
{
#ifdef LSB_FIRST
  struct { pair l,h; } W;
#else
  struct { pair h,l; } W;
#endif
  uint32 DW;
} dpair;


#ifdef __GNUC__
 #ifdef C80x86
  #define FASTAPASS(x) __attribute__((regparm(x)))
  #define FP_FASTAPASS FASTAPASS
 #else
  #define FASTAPASS(x)	
  #define FP_FASTAPASS(x)	
 #endif
#else
 #define FP_FASTAPASS(x)
 #define FASTAPASS(x) __fastcall
#endif

typedef void FP_FASTAPASS(2) (*writefunc)(uint32 A, uint8 V);
typedef uint8 FP_FASTAPASS(1) (*readfunc)(uint32 A);
#endif
