/* TODO:  Battery backup file saving, mirror force */
/* **INCOMPLETE** 				   */
/* Override stuff: CHR RAM instead of CHR ROM,
		   mirroring.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include	"types.h"
#include        "fce.h"
#include        "unif.h"
#include        "version.h"
#include	"svga.h"
#include        "general.h"
#include	"state.h"
#include	"endian.h"
#include	"file.h"
#include	"cart.h"
#include	"memory.h"

#include "..\stdfile.h"

typedef struct {
           char ID[4];
           uint32 info;
} UNIF_HEADER;

typedef struct {
           char *name;
           void (*init)(void);
	   int flags;
} BMAPPING;

typedef struct {
           char *name;
           int (*init)(int fp);
} BFMAPPING;

void (*BoardClose)(void);
void (*BoardPower)(void);
void (*BoardReset)(void);

static int vramo;
static int mirrortodo;
int UNIFbattery;
static uint32 spad;
static char *boardname;
static char *sboardname;

static UNIF_HEADER unhead;
static UNIF_HEADER uchead;


static uint8 *malloced[32];

static int FixRomSize(uint32 size, uint32 minimum)
{
  int x=1;

  if(size<minimum)
   return minimum;
  while(x<size)
   x<<=1;
  return x;
}

static void FreeUNIF(void)
{
 int x;
 if(boardname)
  {free(boardname);boardname=0;}
 for(x=0;x<32;x++)
 {
  if(malloced[x])
   {free(malloced[x]);malloced[x]=0;}
 }
}

static void ResetUNIF(void)
{
 int x;
 for(x=0;x<32;x++)
  malloced[x]=0;
 vramo=0;
 UNIFbattery=0;
 boardname=0;
 mirrortodo=0;
 spad=0;
 BoardReset=BoardPower=BoardClose=0;
}

static uint8 exntar[2048];

static void MooMirroring(void)
{
 if(mirrortodo<0x4)
  SetupCartMirroring(mirrortodo,1,0);
 else if(mirrortodo==0x4)
 {
  SetupCartMirroring(4,1,exntar);
  AddExState(exntar, 2048, 0,"EXNR");
 }
 else
  SetupCartMirroring(0,0,0);
}

/* Proposed extra chunk.  Code not finished. */
static int SolderPad(int fp)
{
 if(!(FCEU_read32(&spad,fp)))
  return(0);
 return(1);
}

static int DoMirroring(int fp)
{
 uint8 t;
 t=FCEU_fgetc(fp);
 mirrortodo=t; 
 return(1);
}

static int EnableBattery(int fp)
{
// puts(" Battery-backed.");
 if(FCEU_fgetc(fp)==EOF)
  return(0);
 UNIFbattery=1;
 return(1);
}

static int LoadPRG(int fp)
{
 int z,t;
 z=uchead.ID[3]-'0';

 if(z<0 || z>15)
  return(0);
// printf(" PRG ROM %d size: %d\n",z,(int) uchead.info);
 if(malloced[z])
  free(malloced[z]);
 t=FixRomSize(uchead.info,2048);
 if(!(malloced[z]=FCEU_malloc(t)))
  return(0);
 memset(malloced[z]+uchead.info,0xFF,t-uchead.info);
 FCEU_fread(malloced[z],1,uchead.info,fp);
 SetupCartPRGMapping(z,malloced[z],t,0); 
 return(1);
}

static int SetBoardName(int fp)
{
 if(!(boardname=FCEU_malloc(uchead.info+1)))
  return(0);
 FCEU_fread(boardname,1,uchead.info,fp);
 boardname[uchead.info]=0;
// printf(" Board name: %s\n",boardname);
 sboardname=boardname;
 if(!memcmp(boardname,"NES-",4) || !memcmp(boardname,"HVC-",4) || !memcmp(boardname,"BTL-",4) || !memcmp(boardname,"BMC-",4))
  sboardname+=4;
 return(1);
}

static int LoadCHR(int fp)
{
 int z,t;
 z=uchead.ID[3]-'0';
 if(z<0 || z>15)
  return(0);
// printf(" CHR ROM %d size: %d\n",z,(int) uchead.info);
 if(malloced[16+z])
  free(malloced[16+z]);
 t=FixRomSize(uchead.info,8192);
 if(!(malloced[16+z]=FCEU_malloc(t)))
  return(0);
 memset(malloced[16+z]+uchead.info,0xFF,t-uchead.info);
 FCEU_fread(malloced[16+z],1,uchead.info,fp);
 SetupCartCHRMapping(z,malloced[16+z],t,0);
 return(1);
}


#define BMCFLAG_FORCE4 1

#define BMC 38

BMAPPING bmap[BMC] = {

// /* AVE carts. */
// { "MB-91", (void *)MB91_Init,0},	// DeathBots
// { "NINA-06", (void *)NINA06_Init,0},	// F-15 City War
// { "NINA-03", (void *)NINA03_Init,0},	// Tiles of Fate
// { "NINA-001", (void *)NINA001_Init,0}, // Impossible Mission 2

 { "HKROM", (void *)HKROM_Init,0},

 { "EWROM", (void *)EWROM_Init,0},
 { "EKROM", (void *)EKROM_Init,0},
 { "ELROM", (void *)ELROM_Init,0},
 { "ETROM", (void *)ETROM_Init,0},

 { "SAROM", (void *)SAROM_Init,0},
 { "SBROM", (void *)SBROM_Init,0},
 { "SCROM", (void *)SCROM_Init,0},
 { "SEROM", (void *)SEROM_Init,0},
 { "SGROM", (void *)SGROM_Init,0},
 { "SKROM", (void *)SKROM_Init,0},
 { "SLROM", (void *)SLROM_Init,0},
 { "SL1ROM", (void *)SL1ROM_Init,0},
 { "SNROM", (void *)SNROM_Init,0},
 { "SOROM", (void *)SOROM_Init,0},

 { "TGROM", (void *)TGROM_Init,0},
 { "TR1ROM", (void *)TFROM_Init,BMCFLAG_FORCE4},
 { "TFROM", (void *)TFROM_Init,0},
 { "TLROM", (void *)TLROM_Init,0},
 { "TKROM", (void *)TKROM_Init,0},
 { "TSROM", (void *)TSROM_Init,0},

 { "TLSROM", (void *)TLSROM_Init,0},
 { "TKSROM", (void *)TKSROM_Init,0},
 { "TQROM", (void *)TQROM_Init,0},
 { "TVROM", (void *)TLROM_Init,BMCFLAG_FORCE4},

 { "CPROM", (void *)CPROM_Init,0},
 { "CNROM", (void *)CNROM_Init,0},
 { "NROM", (void *)NROM256_Init,0 },
 { "RROM", (void *)NROM128_Init,0 },
 { "RROM-128", (void *)NROM128_Init,0 },
 { "NROM-128", (void *)NROM128_Init,0 },
 { "NROM-256", (void *)NROM256_Init,0 },
 { "MHROM", (void *)MHROM_Init,0},
 { "UNROM", (void *)UNROM_Init,0},
 { "MARIO1-MALEE2", (void *)MALEE_Init,0},
 { "Supervision16in1", (void *)Supervision16_Init,0},
 { "NovelDiamond9999999in1", (void *)Novel_Init,0},
 { "Super24in1SC03", (void *)Super24_Init,0}
};

#define BMF 6
BFMAPPING bfunc[BMF] = {
 { "SPAD", (void *)SolderPad },
 { "BATR", (void *)EnableBattery },
 { "MIRR", (void *)DoMirroring },
 { "PRG",  (void *)LoadPRG },
 { "CHR",  (void *)LoadCHR },
 { "MAPR", (void *)SetBoardName }
};

int LoadUNIFChunks(int fp)
{
   int x;
   int t;
   for(;;)
   {
    t=FCEU_fread(&uchead,1,4,fp);
    if(t<4) 
    {
     if(t>0)
      return 0; 
     return 1;
    }
    if(!(FCEU_read32(&uchead.info,fp))) 
     return 0;
    t=0;
    for(x=0;x<BMF;x++)
    {
     if(memcmp(&uchead,bfunc[x].name,strlen(bfunc[x].name)))
      continue;
     if(!bfunc[x].init(fp))
      return 0;
     t=1;
     break;     
    }
    if(!t)
     FCEU_fseek(fp,uchead.info,SEEK_CUR);
   }
}

static int InitializeBoard(void)
{
   int x;

   for(x=0;x<BMC;x++)
   {
    if(strcmp(sboardname,bmap[x].name)) continue;
    if(bmap[x].flags&BMCFLAG_FORCE4)
     mirrortodo=4;
    MooMirroring();
    bmap[x].init();
    return(1);
   }
   return(0);
}

static void UNIFGI(int h)
{
 switch(h)
 {
  case GI_RESETM2:
		if(BoardReset) BoardReset();
		break;
  case GI_POWER:
                if(BoardPower) BoardPower();
		break;
  case GI_CLOSE:
                if(BoardClose)
                 BoardClose();
                FreeUNIF();
                break;
 }
}

int UNIFLoad(char *name, int fp)
{
        FCEU_fseek(fp,0,SEEK_SET);
        FCEU_fread(&unhead,1,4,fp);
        if(memcmp(&unhead,"UNIF",4))
         return 0;        

	ResetCartMapping();

        ResetExState();
        ResetUNIF();
        if(!FCEU_read32(&unhead.info,fp))
	 goto aborto;
        if(FCEU_fseek(fp,0x20,SEEK_SET)<0)
	 goto aborto;
        if(!LoadUNIFChunks(fp))
	 goto aborto;
        if(!InitializeBoard())
	{
	 FCEU_PrintError("Board type not supported.");
	 goto aborto;
	}
        GameInterface=(void *)UNIFGI;        
        return 1;
	
	aborto:

	FreeUNIF();
	ResetUNIF();
	return 0;

}

static FILE *fssp=0;

void UNIFOpenWRAM(int t, char *ext, int override)
{
 if(UNIFbattery|override)
 {
  fssp=fopen(FCEU_MakeFName(0,ext?ext:"sav",-1,FSettings.SUnderBase?"sav":0,0),(t==UOW_RD)?"rb":"wb");
 }
}

void UNIFWriteWRAM(uint8 *p, int size)
{
 if(fssp)
  fwrite(p, size, 1, fssp);
}

void UNIFReadWRAM(uint8 *p, int size)
{
 if(fssp)
  fread(p, size, 1, fssp);
}
void UNIFCloseWRAM(void)
{
 if(fssp)
  fclose(fssp);
 fssp=0;
}
