#include        <string.h>
#include	<stdio.h>
#include	<stdlib.h>

#include	"m6502.h"
#include	"fce.h"
#include        "svga.h"
#include	"general.h"
#include	"endian.h"
#include	"version.h"
#include        "video.h"
#include        "zapper.h"
#include	"input.h"

static ZAPPER ZD[2];

void FASTAPASS(3) ZapperThingy(int w, uint8 *buf, int line)
{
	int mzx=ZD[w].mzx;

	if(ZD[w].mzb&2) return;

	if(line==ZD[w].mzy && mzx<256)
	{
	 int a,sum,diff;

	 a=buf[mzx]&63;
	 sum=palo[a].r+palo[a].g+palo[a].b;
	 
	 diff=sum-ZD[w].lasti;

	 /* This works for most Zapper games, except Chiller.  Arrrgghhh... */
	 /* Changing 236*3 to a lower value(300) makes Chiller work, but
 	    not when one shoots the white portion of objects.  Hmm.
	 */
	 if(diff>=236*3)
	  ZD[w].colok=1;
	 else
	  ZD[w].colok=0;
	 ZD[w].lasti=sum;
	}
}

static uint8 FCEUcursor[11*19]=
{
 1,0,0,0,0,0,0,0,0,0,0,
 1,1,0,0,0,0,0,0,0,0,0,
 1,2,1,0,0,0,0,0,0,0,0,
 1,2,2,1,0,0,0,0,0,0,0,
 1,2,2,2,1,0,0,0,0,0,0,
 1,2,2,2,2,1,0,0,0,0,0,
 1,2,2,2,2,2,1,0,0,0,0,
 1,2,2,2,2,2,2,1,0,0,0,
 1,2,2,2,2,2,2,2,1,0,0,
 1,2,2,2,2,2,2,2,2,1,0,
 1,2,2,2,2,2,1,1,1,1,1,
 1,2,2,1,2,2,1,0,0,0,0,
 1,2,1,0,1,2,2,1,0,0,0,
 1,1,0,0,1,2,2,1,0,0,0,
 1,0,0,0,0,1,2,2,1,0,0,
 0,0,0,0,0,1,2,2,1,0,0,
 0,0,0,0,0,0,1,2,2,1,0,
 0,0,0,0,0,0,1,2,2,1,0,
 0,0,0,0,0,0,0,1,1,0,0,
};

static INLINE int CheckColorVS0(void)
{
  if(ZD[0].colok)
   return 1;
  return 0;
}

static INLINE int CheckColorVS1(void)
{
  if(ZD[1].colok)
   return 1;
  return 0;
}

static INLINE int CheckColor0(void)
{
  if(ZD[0].colok)
   return 0;
  return 1;
}

static INLINE int CheckColor1(void)
{
  if(ZD[1].colok)
   return 0;
  return 1;
}

static DECLFR(AReadZapperVS0)
{
                uint8 ret=0;

                if(ZD[0].zap_readbit==4) ret=1;

                if(ZD[0].zap_readbit==7)
                {
                 if(ZD[0].bogo)
                  ret|=0x1;
                }
                if(ZD[0].zap_readbit==6)
                {
                 if(CheckColorVS0())
                  ret|=0x1;
                }
                ZD[0].zap_readbit++; 
                return ret;
}

static DECLFR(AReadZapperVS1)
{
                uint8 ret=0;
                ret=0;

                if(ZD[1].zap_readbit==4) ret=1;

                if(ZD[1].zap_readbit==7)
                {
                 if(ZD[1].bogo)
                  ret|=0x1;
                }
                if(ZD[1].zap_readbit==6)
                {
                 if(CheckColorVS1())
                  ret|=0x1;
                }
                ZD[1].zap_readbit++;
                return ret;
}

static DECLFW(StrobeVS0)
{                        
			ZD[0].zap_readbit=0;
}

static DECLFW(StrobeVS1)
{                        
			ZD[1].zap_readbit=0;

}

DECLFR(AReadZapper0)
{
                uint8 ret=M.DB&0xE0;

                if(ZD[0].bogo)
                 ret|=0x10;
                if(CheckColor0())
                 ret|=0x8;
                return ret;

}

DECLFR(AReadZapper1)
{
                uint8 ret=M.DB&0xE0;

                if(ZD[1].bogo)
                 ret|=0x10;
                if(CheckColor1())
                 ret|=0x8;
                return ret;
}


void HookZapper(int w)
{
  memset(&ZD[w],0,sizeof(ZAPPER));
  if(GameAttributes&GA_VSUNI)
  {
   if(w)
    {PStrobe[1]=(void *)StrobeVS1;SetReadHandler(0x4017,0x4017,(void *)AReadZapperVS1);}
   else
    {PStrobe[0]=(void *)StrobeVS0;SetReadHandler(0x4016,0x4016,(void *)AReadZapperVS0);}
  }
  else
  {
   if(w)
    SetReadHandler(0x4017,0x4017,(void *)AReadZapper1);
   else
    SetReadHandler(0x4016,0x4016,(void *)AReadZapper0);
  }
}

static INLINE void DrawZapperCursor(int w)
{
 int x,y;
 int c,d;

  if(ZD[w].mzx<256 && ZD[w].mzy<240)
  for(y=0;y<19;y++)
   for(x=0;x<11;x++)
   {
    uint8 a;
    a=FCEUcursor[y*11+x];
    if(a)
    {
     c=(ZD[w].mzy+y);
     d=(ZD[w].mzx+x);
     if(d<256 && c<240)
      XBuf[8+c*272+d]=a+127;
    }
   }
}

void UpdateZapper(int w, uint32 *ptr, int md)
{
  if(ZD[w].bogo)
   ZD[w].bogo--;
  if(ptr[2]&3 && (!(ZD[w].mzb&3)))
   ZD[w].bogo=5;

  ZD[w].mzx=ptr[0];
  ZD[w].mzy=ptr[1];
  ZD[w].mzb=ptr[2];

  if(ZD[w].mzb&2 || ZD[w].mzx>=256 || ZD[w].mzy>=240)
   ZD[w].colok=0;

  if(md)
   DrawZapperCursor(w);
}


