#include	<windows.h>
#include	<stdio.h>
#include	<stdlib.h>

#include	"key.h"


typedef struct {
	int key;
	char * str;
} KEYSTRING;


KEYSTRING CmdStr[MAX_KEYTABLE] = {
	{KEY_START			,"KEY_START" },
	{KEY_SELECT			,"KEY_SELECT" },
	{KEY_P1_A			,"KEY_P1_A" },
	{KEY_P1_B			,"KEY_P1_B" },
	{KEY_P1_TA			,"KEY_P1_TA" },
	{KEY_P1_TB			,"KEY_P1_TB" },
	{KEY_P1_UP			,"KEY_P1_UP" },
	{KEY_P1_DOWN		,"KEY_P1_DOWN" },
	{KEY_P1_LEFT		,"KEY_P1_LEFT" },
	{KEY_P1_RIGHT		,"KEY_P1_RIGHT" },
	{STATE_SELECT_0		,"STATE_SELECT_0" },
	{STATE_SELECT_1		,"STATE_SELECT_1" },
	{STATE_SELECT_2		,"STATE_SELECT_2" },
	{STATE_SELECT_3		,"STATE_SELECT_3" },
	{STATE_SELECT_4		,"STATE_SELECT_4" },
	{STATE_SELECT_5		,"STATE_SELECT_5" },
	{STATE_SELECT_6		,"STATE_SELECT_6" },
	{STATE_SELECT_7		,"STATE_SELECT_7" },
	{STATE_SELECT_8		,"STATE_SELECT_8" },
	{STATE_SELECT_9		,"STATE_SELECT_9" },
	{STATE_SAVE			,"STATE_SAVE" },
	{STATE_LOAD			,"STATE_LOAD" },
	{DISK_EJECT			,"DISK_EJECT" },
	{DISK_INSERT		,"DISK_INSERT" },
	{DISK_SELECT		,"DISK_SELECT" },
	{KEY_RESET			,"KEY_RESET" },
	{QUIT				,"QUIT" }
};

#define KEYSTR_MAX 256

KEYSTRING KeyStr[KEYSTR_MAX] = { 
	{VK_LBUTTON   , "VK_LBUTTON"  },
	{VK_RBUTTON   , "VK_RBUTTON"  },
	{VK_CANCEL    , "VK_CANCEL"   },
	{VK_MBUTTON   , "VK_MBUTTON"  },
	{VK_BACK      , "VK_BACK"     },
	{VK_TAB       , "VK_TAB"      },
	{VK_CLEAR     , "VK_CLEAR"    },
	{VK_RETURN    , "VK_RETURN"   },
	{VK_SHIFT     , "VK_SHIFT"    },
	{VK_CONTROL   , "VK_CONTROL"  },
	{VK_MENU      , "VK_MENU"     },
	{VK_PAUSE     , "VK_PAUSE"    },
	{VK_CAPITAL   , "VK_CAPITAL"  },
	{VK_KANA      , "VK_KANA"     },
//	{VK_JUNJA     , "VK_JUNJA"    },
//	{VK_FINAL     , "VK_FINAL"    },
	{VK_KANJI	 , "VK_KANJI"     },
	{VK_ESCAPE    , "VK_ESCAPE"   },
	{VK_CONVERT	 , "VK_CONVERT"   },
	{VK_NOCONVERT, "VK_NOCONVERT" },
	{VK_SPACE     , "VK_SPACE"    },
	{VK_PRIOR     , "VK_PRIOR"    },
	{VK_NEXT      , "VK_NEXT"     },
	{VK_END       , "VK_END"      },
	{VK_HOME      , "VK_HOME"     },
	{VK_LEFT      , "VK_LEFT"     },
	{VK_UP        , "VK_UP"       },
	{VK_RIGHT     , "VK_RIGHT"    },
	{VK_DOWN      , "VK_DOWN"     },
	{VK_SELECT    , "VK_SELECT"   },
	{VK_PRINT     , "VK_PRINT"    },
	{VK_EXECUTE   , "VK_EXECUTE"  },
	{VK_SNAPSHOT  , "VK_SNAPSHOT" },
	{VK_INSERT    , "VK_INSERT"   },
	{VK_DELETE    , "VK_DELETE"   },
	{VK_HELP      , "VK_HELP"     },
	{'0'          , "0"           },
	{'1'          , "1"           },
	{'2'          , "2"           },
	{'3'          , "3"           },
	{'4'          , "4"           },
	{'5'          , "5"           },
	{'6'          , "6"           },
	{'7'          , "7"           },
	{'8'          , "8"           },
	{'9'          , "9"           },
	{'A'          , "A"           },
	{'B'          , "B"           },
	{'C'          , "C"           },
	{'D'          , "D"           },
	{'E'          , "E"           },
	{'F'          , "F"           },
	{'G'          , "G"           },
	{'H'          , "H"           },
	{'I'          , "I"           },
	{'J'          , "J"           },
	{'K'          , "K"           },
	{'L'          , "L"           },
	{'M'          , "M"           },
	{'N'          , "N"           },
	{'O'          , "O"           },
	{'P'          , "P"           },
	{'Q'          , "Q"           },
	{'R'          , "R"           },
	{'S'          , "S"           },
	{'T'          , "T"           },
	{'U'          , "U"           },
	{'V'          , "V"           },
	{'W'          , "W"           },
	{'X'          , "X"           },
	{'Y'          , "Y"           },
	{'Z'          , "Z"           },
	{VK_LWIN      , "VK_LWIN"     },
	{VK_RWIN      , "VK_RWIN"     },
	{VK_APPS      , "VK_APPS"     },
	{VK_NUMPAD0   , "VK_NUMPAD0"  },
	{VK_NUMPAD1   , "VK_NUMPAD1"  },
	{VK_NUMPAD2   , "VK_NUMPAD2"  },
	{VK_NUMPAD3   , "VK_NUMPAD3"  },
	{VK_NUMPAD4   , "VK_NUMPAD4"  },
	{VK_NUMPAD5   , "VK_NUMPAD5"  },
	{VK_NUMPAD6   , "VK_NUMPAD6"  },
	{VK_NUMPAD7   , "VK_NUMPAD7"  },
	{VK_NUMPAD8   , "VK_NUMPAD8"  },
	{VK_NUMPAD9   , "VK_NUMPAD9"  },
	{VK_MULTIPLY  , "VK_MULTIPLY" },
	{VK_ADD       , "VK_ADD"      },
	{VK_SEPARATOR , "VK_SEPARATOR"},
	{VK_SUBTRACT  , "VK_SUBTRACT" },
	{VK_DECIMAL   , "VK_DECIMAL"  },
	{VK_DIVIDE    , "VK_DIVIDE"   },
	{VK_F1        , "VK_F1"    },
	{VK_F2        , "VK_F2"    },
	{VK_F3        , "VK_F3"    },
	{VK_F4        , "VK_F4"    },
	{VK_F5        , "VK_F5"    },
	{VK_F6        , "VK_F6"    },
	{VK_F7        , "VK_F7"    },
	{VK_F8        , "VK_F8"    },
	{VK_F9        , "VK_F9"    },
	{VK_F10       , "VK_F10"   },
	{VK_F11       , "VK_F11"   },
	{VK_F12       , "VK_F12"   },
	{VK_F13       , "VK_F13"   },
	{VK_F14       , "VK_F14"   },
	{VK_F15       , "VK_F15"   },
	{VK_F16       , "VK_F16"   },
	{VK_F17       , "VK_F17"   },
	{VK_F18       , "VK_F18"   },
	{VK_F19       , "VK_F19"   },
	{VK_F20       , "VK_F20"   },
	{VK_F21       , "VK_F21"   },
	{VK_F22       , "VK_F22"   },
	{VK_F23       , "VK_F23"   },
	{VK_F24       , "VK_F24"   },
	{VK_NUMLOCK   , "VK_NUMLOCK"   },
	{VK_SCROLL    , "VK_SCROLL"    },
	{VK_LSHIFT    , "VK_LSHIFT"    },
	{VK_RSHIFT    , "VK_RSHIFT"    },
	{VK_LCONTROL  , "VK_LCONTROL"  },
	{VK_RCONTROL  , "VK_RCONTROL"  },
	{VK_LMENU     , "VK_LMENU"     },
	{VK_RMENU     , "VK_RMENU"     },
	{VK_EXTEND_BSLASH , "VK_EXTEND_BSLASH" },
	{VK_OEM_102       , "VK_OEM_102"       },
	{VK_PROCESSKEY    , "VK_PROCESSKEY"    },
	{VK_ATTN          , "VK_ATTN"          },
	{VK_CRSEL         , "VK_CRSEL"         },
	{VK_EXSEL         , "VK_EXSEL"         },
	{VK_EREOF         , "VK_EREOF"         },
	{VK_PLAY          , "VK_PLAY"          },
	{VK_ZOOM          , "VK_ZOOM"          },
	{VK_NONAME        , "VK_NONAME"        },
	{VK_PA1           , "VK_PA1"           },
	{VK_OEM_CLEAR     , "VK_OEM_CLEAR"     },
	{VK_SEMICOLON	 , "VK_SEMICOLON"	   },
	{VK_EQUAL		 , "VK_EQUAL"	       },
	{VK_COMMA		 , "VK_COMMA"	       },
	{VK_HYPHEN		 , "VK_HYPHEN"	       },
	{VK_PERIOD		 , "VK_PERIOD"	       },
	{VK_SLASH		 , "VK_SLASH"	       },
	{VK_BACKQUOTE	 , "VK_BACKQUOTE"	   },
	{VK_LBRACKET	 , "VK_LBRACKET"	   },
	{VK_BACKSLASH	 , "VK_BACKSLASH"      },
	{VK_RBRACKET	 , "VK_RBRACKET"       },
	{VK_APOSTROPHE	 , "VK_APOSTROPHE"	   },
	{VK_OFF          , "VK_OFF"            },
	{0 , NULL  }
};     
                   
int KeyTable[MAX_KEYTABLE];

void setDefaultKeyTable()
{
	memset( KeyTable,'\0',sizeof(KeyTable));

	KeyTable[KEY_START		] = VK_RETURN;
	KeyTable[KEY_SELECT		] = VK_TAB;
	KeyTable[KEY_P1_A		] = 'X';
	KeyTable[KEY_P1_B		] = 'Z';
	KeyTable[KEY_P1_TA  	] = 'C';
	KeyTable[KEY_P1_TB		] = 'A';
	KeyTable[KEY_P1_UP		] = VK_UP;
	KeyTable[KEY_P1_DOWN	] = VK_DOWN;
	KeyTable[KEY_P1_LEFT	] = VK_LEFT;
	KeyTable[KEY_P1_RIGHT	] = VK_RIGHT;
	KeyTable[QUIT			] = VK_ESCAPE;
	KeyTable[KEY_RESET      ] = 'Q';

	KeyTable[STATE_SELECT_1 ] = '1';
	KeyTable[STATE_SELECT_2 ] = '2';
	KeyTable[STATE_SELECT_3 ] = '3';
	KeyTable[STATE_SELECT_4 ] = '4';
	KeyTable[STATE_SELECT_5 ] = '5';
	KeyTable[STATE_SELECT_6 ] = '6';
	KeyTable[STATE_SELECT_7 ] = '7';
	KeyTable[STATE_SELECT_8 ] = '8';
	KeyTable[STATE_SELECT_9 ] = '9';
	KeyTable[STATE_SELECT_0 ] = '0';
	KeyTable[STATE_SAVE     ] = VK_HYPHEN; 
	KeyTable[STATE_LOAD     ] = VK_APOSTROPHE;

	KeyTable[DISK_EJECT 	] = 'E';
	KeyTable[DISK_INSERT	] = 'I';
	KeyTable[DISK_SELECT	] = 'S';

}

int Key2Command(int k)
{
	int i;
	for(i=0;i<MAX_KEYTABLE;i++){
		if( KeyTable[i] == k )	return i;
	}
	return -1;
}

int atoiKey( char * str )
{
	int i = 0;
	DEBUGLOG( "atoiKey Start [%s]\n", str );
	if( !str ) return -1;
	for( i=0;i<KEYSTR_MAX;i++ ){
		if( !strcmp(str, KeyStr[i].str) ) return KeyStr[i].key;
	}
	DEBUGLOG( "atoiKey End\n" );
	return -1;
}

int atoiCommand( char * str )
{
	int i = 0;
	DEBUGLOG( "atoiCommand Start [%s]\n", str );
	if( !str ) return -1;
	for( i=0;i<MAX_KEYTABLE;i++ ){
		if( CmdStr[i].str == NULL ) break;
		if( !strcmp(str, CmdStr[i].str) ) return CmdStr[i].key;
	}
	DEBUGLOG( "atoiCommand End\n" );
	return -1;

}

void DefineKey( char * cmd, char * key )
{
	int icmd, ikey;
	DEBUGLOG( "DefineKey Start\n" );
	icmd = atoiCommand( cmd );
	DEBUGLOG( "atoiCommand ret[%d]\n", icmd );
	if( icmd == -1 ) return;
	ikey = atoiKey( key );
	DEBUGLOG( "atoiKey ret[%d]\n", ikey );
	if( ikey == -1 ) return;

	KeyTable[icmd] = ikey;
	DEBUGLOG( "DefineKey End\n" );
}