#include "stdafx.h"
#include "resource.h"

#include <windows.h>
#include <commctrl.h>
#include <commdlg.h>
#include <stdlib.h>
#include <tchar.h>

#define MAX_LOADSTRING 100

extern "C" {
#include "fceu\driver.h"
#include "fceu\svga.h"
#include "key.h"

int errno;

HINSTANCE hInst;
HWND hWndNES;
HWND hwndCB;
//HBITMAP bmpTitle;

extern void KeyBoardInit();
extern uint32 JSreturn;
extern void ReadIniFile(HINSTANCE hInst);
extern int InitSound(void);
extern void TrashSound(void);
int CommandBarVis;
char gDefaultDir[512];
void ToggleTurboSW( int );
extern int gametype;

extern int opt_AutoStateLoading;
extern int opt_AutoStateTiming;
#include "fceu\state.h"

}
int bThreadRunning;
char szRomFileName[128];
int exiting = false;
int gameloaded = false;
char bkCmdline[512];

ATOM MyRegisterClass(HINSTANCE hInstance, LPTSTR szWindowClass);
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow);
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
HWND CreateRpCommandBar(HWND hwnd);
void DoPaint(HWND hWnd);
void OpenNewGame(HWND hWnd, LPTSTR fname );
int mainloop();


extern "C" void DEBUGLOG( char * str , ... );


int WINAPI WinMain(	HINSTANCE hInstance,
					HINSTANCE hPrevInstance,
					LPTSTR    lpCmdLine,
					int       nCmdShow)
{
	MSG msg;
	HACCEL hAccelTable;

	DEBUGLOG("\n\ndebug start\n");
	
	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}


	if( *lpCmdLine ){
		OpenNewGame(hWndNES, lpCmdLine );
	}

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_NESCE);

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return msg.wParam;
}

// MyRegisterClass
ATOM MyRegisterClass(HINSTANCE hInstance, LPTSTR szWindowClass)
{
	WNDCLASS	wc;

    wc.style			= CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc		= (WNDPROC) WndProc;
    wc.cbClsExtra		= 0;
    wc.cbWndExtra		= 0;
    wc.hInstance		= hInstance;
    wc.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_NESCE));
    wc.hCursor			= 0;
    wc.hbrBackground	= (HBRUSH) GetStockObject(BLACK_BRUSH);
    wc.lpszMenuName		= 0;
    wc.lpszClassName	= szWindowClass;

	return RegisterClass(&wc);
}



//  FUNCTION: InitInstance(HANDLE, int)
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	HWND	hWnd = NULL;
	TCHAR	szTitle[MAX_LOADSTRING];			// The title bar text
	TCHAR	szWindowClass[MAX_LOADSTRING];		// The window class name

	DEBUGLOG("InitInstance Start\n");
	
	hInst = hInstance;		// Store instance handle in our global variable
	// Initialize global strings
	LoadString(hInstance, IDC_NESCE, szWindowClass, MAX_LOADSTRING);
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);

	DEBUGLOG("InitInstance 1\n");

//	bmpTitle = LoadBitmap(hInst,MAKEINTRESOURCE(IDB_BITMAP));

	//If it is already running, then focus on the window
	hWnd = FindWindow(szWindowClass, szTitle);	
	if (hWnd) 
	{
		SetForegroundWindow ((HWND) (((DWORD)hWnd) | 0x01));    
		return 0;
	} 

	DEBUGLOG("InitInstance 2\n");

	MyRegisterClass(hInstance, szWindowClass);
	
	RECT	rect;
	GetClientRect(hWnd, &rect);
	
	hWnd = CreateWindow(szWindowClass, szTitle, WS_VISIBLE,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInstance, NULL);
	if (!hWnd)
	{	
		return FALSE;
	}

	DEBUGLOG("InitInstance 3\n");

	//When the main window is created using CW_USEDEFAULT the height of the menubar (if one
	// is created is not taken into account). So we resize the window after creating it
	// if a menubar is present
/*
	{
		RECT rc;
		GetWindowRect(hWnd, &rc);
		rc.bottom -= MENU_HEIGHT;
		if (hwndCB)
			MoveWindow(hWnd, rc.left, rc.top, rc.right, rc.bottom, FALSE);
	}
*/

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	gDefaultDir[0] = 0;

	// save the handle to this window for other functions to use
	hWndNES = hWnd;

	DEBUGLOG("InitInstance 4\n");

	FCEUI_Initialize();
	DEBUGLOG("InitInstance 5\n");
	KeyBoardInit();

	DEBUGLOG("InitInstance 6\n");

	ReadIniFile(hInst);

	DEBUGLOG("InitInstance 7\n");

	InitSound();

	DEBUGLOG("InitInstance End\n");
	return TRUE;
}

//------------------------------------------------------
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
//	HDC hdc;
	int wmId, wmEvent;

//	TCHAR szHello[MAX_LOADSTRING];

//	int keycode;

//	int XPos, YPos;
//	int Index;
//	RECT rect;
//	HPEN hPen, hOldPen;
//	TCHAR szMessage[256];

	switch (message) 
	{
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// Parse the menu selections:
			switch (wmId)
			{	
/*				case IDM_HELP_ABOUT:
					bRemappingKey = FALSE;
					DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
				    break;
*/
				case IDM_FILE_OPEN:
					OpenNewGame(hWnd, NULL );
					break;
/*
				case IDM_FILE_OPTIONS:
					bRemappingKey = FALSE;
					DialogBox(hInst, (LPCTSTR)IDD_OPTIONS, hWnd, (DLGPROC)Options);
					break;
*/
/*				case IDM_FILE_RUN:
					DriverInterface(DES_POWER,0);
					break;
*/				case IDM_FILE_EXIT:
					FCEUI_CloseGame();
					SendMessage (hWnd, WM_CLOSE, 0, 0);
					break;
				case IDOK:
					SendMessage(hWnd, WM_ACTIVATE, MAKEWPARAM(WA_INACTIVE, 0), (LPARAM)hWnd);
					SendMessage (hWnd, WM_CLOSE, 0, 0);
					break;
				default:
				   return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;
		case WM_CREATE:
			hwndCB = CreateRpCommandBar(hWnd);
			break;
		case WM_PAINT:
			DoPaint(hWnd);
			break; 
		case WM_DESTROY:
			TrashSound();
			CommandBar_Destroy(hwndCB);
			// destroy and free heap used throughout program
			PostQuitMessage(0);
			break;
//		case WM_SETTINGCHANGE:
//			SHHandleWMSettingChange(hWnd, wParam, lParam, &s_sai);
//     		break;
		case WM_KEYDOWN:
			// Disk 
			switch(Key2Command(wParam))
			{ 
				// TurboSW
				case KEY_P1_TA  : ToggleTurboSW(0);break;
				case KEY_P1_TB  : ToggleTurboSW(1);break;
				case KEY_RESET  : DriverInterface(DES_RESET,0); break;    
				// Disk
				case DISK_SELECT: if( gametype==3) DriverInterface(DES_FDSSELECT,0);break;
				case DISK_INSERT: if( gametype==3) DriverInterface(DES_FDSINSERT,0);break;
				case DISK_EJECT : if( gametype==3) DriverInterface(DES_FDSEJECT ,0);break;
				// Save State
				case STATE_SELECT_0 : DriverInterface(DES_SELECTSTATE,(void *)0); break;
				case STATE_SELECT_1 : DriverInterface(DES_SELECTSTATE,(void *)1); break;
				case STATE_SELECT_2 : DriverInterface(DES_SELECTSTATE,(void *)2); break;
				case STATE_SELECT_3 : DriverInterface(DES_SELECTSTATE,(void *)3); break;
				case STATE_SELECT_4 : DriverInterface(DES_SELECTSTATE,(void *)4); break;
				case STATE_SELECT_5 : DriverInterface(DES_SELECTSTATE,(void *)5); break;
				case STATE_SELECT_6 : DriverInterface(DES_SELECTSTATE,(void *)6); break;
				case STATE_SELECT_7 : DriverInterface(DES_SELECTSTATE,(void *)7); break;
				case STATE_SELECT_8 : DriverInterface(DES_SELECTSTATE,(void *)8); break;
				case STATE_SELECT_9 : DriverInterface(DES_SELECTSTATE,(void *)9); break;
				case STATE_SAVE     : DriverInterface(DES_SAVESTATE,0); break;
				case STATE_LOAD     : DriverInterface(DES_LOADSTATE,0); break;
			}			
			return 0;
			break;	

/*		case WM_KEYUP:
		{
			uint32 JS;
			int x,y;
			x=y=JS=0;

			if( wParam==VK_UP     )  y&= !JOY_UP;
			if( wParam==VK_DOWN   )  y&= !JOY_DOWN;
			if( wParam==VK_LEFT   )  x&= !JOY_LEFT;
			if( wParam==VK_RIGHT  )  x&= !JOY_RIGHT;
		    if( y!=((!JOY_DOWN)|(!JOY_UP)))     JS|= y;
		    if( x!=(JOY_LEFT|JOY_RIGHT))  JS|= x;
		    if( wParam=='X'       ) JS|= !JOY_A;
		    if( wParam=='Z'       ) JS|= !JOY_B;
		    if( wParam==VK_RETURN ) JS|= !JOY_START;
		    if( wParam==VK_TAB    ) JS|= !JOY_SELECT;

			JSreturn=(JS&0xFF000000)|(JS&0xFF)|((JS&0xFF0000)>>8)|((JS&0xFF00)<<8);
		}
			return 0;
			break;

		case WM_KILLFOCUS:
			break;

		case WM_SETFOCUS:
			break;

		case WM_LBUTTONDOWN:
			CommandBarVis = CommandBar_Show( hwndCB, CommandBarVis );
			break;
*/
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
   }
   return 0;
}

HWND CreateRpCommandBar(HWND hwnd)
{
	HWND hcb;
	BOOL res;

	hcb = CommandBar_Create( hInst, hwnd, 1 );
	res = CommandBar_InsertMenubar( hcb, hInst, IDM_MENU, 0 );	

	return hcb;
}



#ifndef POPOPE
void OpenNewGame(HWND hWnd, LPTSTR fname )
{
	TCHAR szFileName[256];
	TCHAR szDir[256];
	DWORD rc;
	HANDLE hThread;
	int i;
	
	int ret;

	DEBUGLOG( "OpenNewGame Start\n" );

	if ( !fname ){
		TCHAR filter[] = _T("NES Files(*.nes,*.nsf,*.fds)\0*.nes;*.nsf;*.fds\0Zip Files(*.zip)\0*.zip\0All files (*.*)\0*.*\0");
		OPENFILENAME ofn;

		DEBUGLOG( "OpenNewGame 1\n" );

		szFileName[0] = 0;
		// convert default rom dir
		for(i = 0; gDefaultDir[i] != 0; i++)
			szDir[i] = (TCHAR)gDefaultDir[i];
		szDir[i] = 0;

		memset(&ofn,0,sizeof(ofn));

    ofn.hwndOwner     = hWnd;
    ofn.lStructSize		= sizeof(ofn);
		ofn.lpstrFilter		= filter;
		ofn.lpstrFile		  = szFileName;
		ofn.nMaxFile		  = 256;
		ofn.Flags			    = OFN_EXPLORER | OFN_ENABLETEMPLATE;
		if(szDir[0]) ofn.lpstrInitialDir = szDir;
		DEBUGLOG( "OpenNewGame 2\n" );

		// display a open file dialog
		ret = GetOpenFileName(&ofn);
		DEBUGLOG( "OpenNewGame 3\n" );

		if( ret ){
			// UNICODE -> char
			for(i = 0; szFileName[i] != 0; i++)
				szRomFileName[i] = (char)szFileName[i];
			szRomFileName[i] = 0;
		}
		DEBUGLOG( "OpenNewGame 4\n" );
	}else{
		DEBUGLOG( "OpenNewGame 5\n" );
		ret = true;
		// UNICODE -> char
		for(i = 0; fname[i] != 0; i++)
			szRomFileName[i] = (char)fname[i];
		szRomFileName[i] = 0;
		DEBUGLOG( "OpenNewGame 6\n" );
	}
	DEBUGLOG( "OpenNewGame 7\n" );

	if(ret)
	{
		DEBUGLOG( "OpenNewGame 8\n" );

		if ( FCEUI_LoadGame(szRomFileName) ){
			DEBUGLOG( "OpenNewGame 9      (After FCEUI_LoadGame OK)\n" );
			gameloaded = true;
			SetForegroundWindow(hWnd);
		}else{
			DEBUGLOG( "OpenNewGame 10     (After FCEUI_LoadGame NG)\n" );
			gameloaded = false;
			return;
		}	

		// start a new emulation thread
		bThreadRunning = TRUE;

		// start a thread to play the game
		hThread = CreateThread(NULL, 
			0,		// stack size (ignored)
			(LPTHREAD_START_ROUTINE)mainloop,	// Thread function
			0,		// 32 bit parameter passed to thread
			0,		// Creation flags (0 = start thread immediately)
			&rc);	// Receives thread ID

		CloseHandle(hThread);
		DEBUGLOG( "OpenNewGame 11\n" );

		CommandBarVis = CommandBar_Show( hwndCB, false );

	}

  if( opt_AutoStateLoading ){
	Sleep( opt_AutoStateTiming );
	CurrentState=99;
	LoadState();
	CurrentState=0;
  }

	DEBUGLOG( "OpenNewGame END\n" );

}
#else // ======================================Pocket PostPet OpenDialog =========
HINSTANCE g_hModuleCDQ = 0;
int (pascal *FileDialog) (HWND,TCHAR*,TCHAR*,int);
int CDQ_LoadLibrary();
void CDQ_FreeLibrary();

void OpenNewGame(HWND hWnd, LPTSTR fname )
{
	TCHAR name2[MAX_PATH];
	int ret,len;
	name2[0] = 0;
	DWORD rc;
	HANDLE hThread;
  int i;
	DEBUGLOG( "OpenNewGame Start\n" );

  if( fname == 0 ){
	  // CDQ [h
	  if (!CDQ_LoadLibrary()) {
		  CDQ_FreeLibrary();
		  MessageBox (hWnd, _T("CDQ[hł܂"), NULL, MB_OK);
	  }

    DEBUGLOG( "OpenNewGame 1\n" );

    // convert default rom dir
		for(i = 0; gDefaultDir[i] != 0; i++)
			name2[i] = (TCHAR)gDefaultDir[i];
		name2[i] = 0;
	  wcscat( name2, _T("\\") );

    DEBUGLOG( "OpenNewGame 2\n" );

    ret = FileDialog (		//߂lFIDOK/IDCANCEL
		  hWnd, 				//(i):eEChEEnh
		  _T("ROM Select"),//(i):^Cg
		  name2,			//(i/o):t@C
		  1 );			//(i):݂t@Ĉ=1

	  // CDQ J
	  CDQ_FreeLibrary();
  }else{
    ret=IDOK;
    wcscpy( name2, fname );
  }
  DEBUGLOG( "OpenNewGame 3 FileDialog ret =[%d]\n", ret );
    
  if( ret==IDOK ){
    DEBUGLOG( "OpenNewGame 4\n" );

    len = wcslen(name2);
    DEBUGLOG( "OpenNewGame 5-1\n" );
	  wcstombs(szRomFileName, name2, len + 1);

    DEBUGLOG( "OpenNewGame 5-2 [%s]\n", szRomFileName );

		if ( FCEUI_LoadGame(szRomFileName) ){
			DEBUGLOG( "OpenNewGame 6      (After FCEUI_LoadGame OK)\n" );
			gameloaded = true;
			SetForegroundWindow(hWnd);
		}else{
			DEBUGLOG( "OpenNewGame 7     (After FCEUI_LoadGame NG)\n" );
			gameloaded = false;
			return;
		}	
	
		// start a new emulation thread
		bThreadRunning = TRUE;

		// start a thread to play the game
		hThread = CreateThread(NULL, 
			0,		// stack size (ignored)
			(LPTHREAD_START_ROUTINE)mainloop,	// Thread function
			0,		// 32 bit parameter passed to thread
			0,		// Creation flags (0 = start thread immediately)
			&rc);	// Receives thread ID

		CloseHandle(hThread);
		DEBUGLOG( "OpenNewGame 8\n" );

		CommandBarVis = CommandBar_Show( hwndCB, false );
   
  }

  if( opt_AutoStateLoading ){
	Sleep( opt_AutoStateTiming );
	CurrentState=99;
	LoadState();
	CurrentState=0;
  }

  DEBUGLOG( "OpenNewGame END\n" );
}


//---------------------------------------------------------------
// CDQ 
int CDQ_LoadLibrary()
{
	// DLL擾iWindowsfBNgɖƂ̓tpXŎw肷j
	g_hModuleCDQ = LoadLibrary (_T("CDQ.DLL"));
	if (g_hModuleCDQ == 0) {
		return FALSE;
	}

  FileDialog = (int (pascal *) (HWND,TCHAR*,TCHAR*,int)) 
			GetProcAddress (g_hModuleCDQ, TEXT("FileDialog"));
	if (FileDialog == 0) return FALSE;	//G[

	return TRUE;
}


//---------------------------------------------------------------
// CDQ ㏈
void CDQ_FreeLibrary()
{
	// DLLJ
	if (g_hModuleCDQ)
		FreeLibrary (g_hModuleCDQ);
	g_hModuleCDQ = 0;
}
//---------------------------------------------------------------
#endif

void DrawBitmap(HDC hdc, HBITMAP hBitmap, int xStart, int yStart)
{
	BITMAP	bm;
	HDC		hdcMem;
	POINT	ptSize, ptOrg;

	hdcMem = CreateCompatibleDC(hdc);
	SelectObject(hdcMem, hBitmap);

	GetObject(hBitmap, sizeof(BITMAP), (LPVOID)&bm);

	ptSize.x = bm.bmWidth;
	ptSize.y = bm.bmHeight;

	ptOrg.x = 0;
	ptOrg.y = 0;

	BitBlt(hdc, xStart, yStart, ptSize.x, ptSize.y,
		hdcMem, ptOrg.x, ptOrg.y, SRCCOPY);

	DeleteDC(hdcMem);
}

void DoPaint(HWND hWnd)
{
	RECT rect;
	HPEN hPen, hOldPen;
//	HDC hdcMem;
	HDC hdc;
//	HGDIOBJ hOldSel;
	PAINTSTRUCT ps;
	
	hdc = BeginPaint(hWnd, &ps);
	if(!bThreadRunning)
	{
//		DrawBitmap(hdc, bmpTitle, 160, 40);

/*		GetClientRect(hWnd, &rect);
		rect.bottom -= 10;
		rect.top = rect.bottom - 40;

		// clear the area where the text will be drawn
		hPen = CreatePen(PS_NULL, 1, RGB(0, 0, 0));
		hOldPen = (HPEN)SelectObject(hdc, hPen);
		Rectangle(hdc, rect.left, rect.top, rect.right, rect.bottom);
		SelectObject(hdc, hOldPen);
		DeleteObject(hPen);

		DrawText(hdc, _T("nesCE JORNADA 7x0"), -1, &rect, DT_CENTER | DT_WORDBREAK);
*/
	}

	EndPaint(hWnd, &ps);
}

int mainloop()
{
	FCEUI_Emulate();
	bThreadRunning = false;
	return(0);
}
